/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.layout.LayoutHelper;
import net.createmod.catnip.layout.PaginationState;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.registration.PonderIndexExclusionHelper;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_768;

public class PonderIndexScreen
extends AbstractPonderScreen {
    protected final List<ItemEntry> items;
    protected List<PonderButton> paginatedWidgets = new ArrayList<PonderButton>();
    protected PaginationState paginationState = new PaginationState();
    protected class_768 maxScreenArea = new class_768(0, 0, 0, 0);
    protected class_768 usedArea = new class_768(0, 0, 0, 0);
    protected int maxItemRows;
    protected int maxItemsPerRow;
    protected int maxItemsPerPage;
    @Nullable
    protected PonderButton nextPage;
    @Nullable
    protected PonderButton prevPage;
    private class_1799 hoveredItem = class_1799.field_8037;
    private final List<Predicate<class_1935>> exclusions;

    public PonderIndexScreen() {
        this.items = new ArrayList<ItemEntry>();
        this.exclusions = PonderIndex.streamPlugins().flatMap(PonderIndexExclusionHelper::pluginToExclusions).toList();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.items.clear();
        PonderIndex.getSceneAccess().getRegisteredEntries().stream().map(Map.Entry::getKey).distinct().map(key -> new ItemEntry(CatnipServices.REGISTRIES.getItemOrBlock((class_2960)key), (class_2960)key)).filter(entry -> entry.item != null).filter(this::isItemIncluded).forEach(this.items::add);
        this.items.sort(Comparator.comparing(ItemEntry::key));
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int targetWidth = class_3532.method_15340((int)(this.field_22789 - 180), (int)250, (int)400);
        int targetHeight = class_3532.method_15340((int)(this.field_22790 - 140), (int)150, (int)300);
        this.maxScreenArea = new class_768(centerX - targetWidth / 2, centerY - targetHeight / 2, targetWidth, targetHeight);
        this.maxItemRows = (this.maxScreenArea.method_3320() + 8) / 36;
        this.maxItemsPerRow = (this.maxScreenArea.method_3319() + 8) / 36;
        this.maxItemsPerPage = this.maxItemRows * this.maxItemsPerRow;
        this.paginationState = new PaginationState(this.items.size() > this.maxItemsPerPage, this.maxItemsPerPage, this.items.size());
        this.setupItemsForPage();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        this.prevPage = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(centerX - 100, this.maxScreenArea.method_3322() + this.maxScreenArea.method_3320() + 10).showing(PonderGuiTextures.ICON_PONDER_LEFT)).withCallback(() -> {
            this.paginationState.previousPage();
            this.updateAfterPaginationChange();
        })).setActive(false);
        this.method_37063(this.prevPage);
        this.nextPage = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(centerX + 80, this.maxScreenArea.method_3322() + this.maxScreenArea.method_3320() + 10).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).withCallback(() -> {
            this.paginationState.nextPage();
            this.updateAfterPaginationChange();
        })).setActive(true);
        this.method_37063(this.nextPage);
        this.prevPage.updateGradientFromState();
        this.nextPage.updateGradientFromState();
    }

    protected void setupItemsForPage() {
        this.removeWidgets(this.paginatedWidgets);
        int itemCount = this.paginationState.getCurrentPageElementCount();
        int actualItemRows = class_3532.method_15340((int)((int)Math.ceil((double)itemCount / (double)this.maxItemsPerRow)), (int)1, (int)this.maxItemRows);
        LayoutHelper layoutHelper = LayoutHelper.centeredHorizontal(itemCount, actualItemRows, 28, 28, 8);
        this.usedArea = layoutHelper.getArea();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.paginationState.iterateForCurrentPage((iPage, iOverall) -> {
            ItemEntry entry = this.items.get((int)iOverall);
            PonderButton b = (PonderButton)((AbstractSimiWidget)new PonderButton(centerX + layoutHelper.getX() + 4, centerY + layoutHelper.getY() + 4).showing(new class_1799(entry.item))).withCallback((x, y) -> {
                if (!PonderIndex.getSceneAccess().doScenesExistForId(entry.key)) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new class_1799(entry.item)));
            });
            this.paginatedWidgets.add(b);
            this.method_37063(b);
            layoutHelper.next();
        });
    }

    protected void updateAfterPaginationChange() {
        this.setupItemsForPage();
        ((PonderButton)this.prevPage.setActive(this.paginationState.hasPreviousPage())).animateGradientFromState();
        ((PonderButton)this.nextPage.setActive(this.paginationState.hasNextPage())).animateGradientFromState();
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(PonderGuiTextures.ICON_PONDER_IDENTIFY);
    }

    private boolean isItemIncluded(ItemEntry entry) {
        return this.exclusions.stream().noneMatch(predicate -> predicate.test(entry.item));
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++PonderUI.ponderTicks;
        this.hoveredItem = class_1799.field_8037;
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        for (class_364 child : this.method_25396()) {
            PonderButton button;
            if (!(child instanceof PonderButton) || !(button = (PonderButton)child).method_25405(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem() != null ? button.getItem() : class_1799.field_8037;
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)centerX, (float)centerY, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, this.usedArea.method_3321() - 10, this.usedArea.method_3322() - 20, 20, 220);
        graphics.method_51433(this.field_22793, "Items to inspect", this.usedArea.method_3321() - 5, this.usedArea.method_3322() - 25, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.method_22909();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416((float)centerX, (float)(this.maxScreenArea.method_3322() + this.maxScreenArea.method_3320() + 14), 0.0f);
        poseStack.method_22905(1.5f, 1.5f, 1.0f);
        String pageString = "Page " + (this.paginationState.getPageIndex() + 1) + "/" + this.paginationState.getMaxPages();
        int stringWidth = this.field_22793.method_1727(pageString);
        UIRenderHelper.streak(graphics, 0.0f, 0, 4, 14, 85);
        UIRenderHelper.streak(graphics, 180.0f, 0, 4, 14, 85);
        graphics.method_51433(this.field_22793, pageString, (int)((float)(-stringWidth) / 2.0f), 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.method_22909();
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.method_7960()) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 200.0f);
        graphics.method_51446(this.field_22793, this.hoveredItem, mouseX, mouseY);
        poseStack.method_22909();
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public record ItemEntry(@Nullable class_1935 item, class_2960 key) {
    }
}

